IF NOT EXISTS (SELECT * FROM sys.tables WHERE [type]='U' AND [name]='CAPI_CasesToSendBack') BEGIN

	CREATE TABLE [dbo].[CAPI_CasesToSendBack](
		[Respondent] [varchar](10) NOT NULL,
		[Interviewer] [nvarchar](50) NOT NULL,
	 CONSTRAINT [PK_CAPI_CasesToSendBack] PRIMARY KEY CLUSTERED 
	(
		[Respondent] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
	) ON [PRIMARY]

	CREATE UNIQUE NONCLUSTERED INDEX [IX_CAPI_CasesToSendBack] ON [dbo].[CAPI_CasesToSendBack] 
	(
		[Interviewer] ASC,
		[Respondent] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]



END
GO

-- Rename 'Done' column by 'Frequency'
IF EXISTS (SELECT t.[name] as 'TableName',c.* FROM sys.columns AS c INNER JOIN sys.tables AS t ON c.[object_id]=t.[object_id] 
WHERE t.[Name]='QuotasAgent' AND c.[name]='Done') 
BEGIN
	ALTER TABLE QuotasAgent DROP COLUMN Done ;
	ALTER TABLE QuotasAgent ADD Frequency INT NULL ;
END
GO

-- Drop Sent column
--IF EXISTS (SELECT t.[name] as 'TableName',c.* FROM sys.columns AS c INNER JOIN sys.tables AS t ON c.[object_id]=t.[object_id] 
--WHERE t.[Name]='QuotasAgent' AND c.[name]='Sent') 
--BEGIN
--	ALTER TABLE QuotasAgent DROP COLUMN Sent;
--END
--GO


